*                                                                                  ;
 *    Reading in the 1973 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam73.raw' ;
 
 data one;
 
   infile 'F:\PSID\73FAM.DAT'  lrecl=566 missover;
   INPUT
   V3001 1-3              V3002 4-7              V3003 8-9
   V3004 10-12            V3005 13-17            V3006 18
   V3007 19               V3008 20               V3009 21
   V3010 22               V3011 23               V3012 24
   V3013 25               V3014 26               V3015 27
   V3016 28               V3017 29-30            V3018 31
   V3019 32-36 .2         V3020 37-41            V3021 42-46
   V3022 47               V3023 48-51            V3024 52
   V3025 53-56            V3026 57               V3027 58-61
   V3028 62               V3029 63-66            V3030 67
   V3031 68-71            V3032 72               V3033 73-75
   V3034 76               V3035 77-80            V3036 81
   V3037 82-85            V3038 86               V3039 87-90
   V3040 91               V3041 92-95            V3042 96
   V3043 97               V3044 98               V3045 99
   V3046 100-104          V3047 105              V3048 106
   V3049 107              V3050 108              V3051 109-113
   V3052 114              V3053 115-119          V3054 120
   V3055 121              V3056 122              V3057 123
   V3058 124              V3059 125              V3060 126-130
   V3061 131              V3062 132-136          V3063 137
   V3064 138-142          V3065 143-147          V3066 148
   V3067 149-153          V3068 154-158          V3069 159-163
   V3070 164-168          V3071 169-173          V3072 174
   V3073 175              V3074 176              V3075 177
   V3076 178-182          V3077 183-186          V3078 187-191
   V3079 192              V3080 193-197          V3081 198-202
   V3082 203              V3083 204              V3084 205
   V3085 206-209          V3086 210-213          V3087 214-217
   V3088 218-221          V3089 222-225          V3090 226-234
   V3091 235-236          V3092 237              V3093 238-240
   V3094 241-242          V3095 243-244          V3096 245
   V3097 246-247          V3098 248-249          V3099 250-251
   V3100 252              V3101 253              V3102 254
   V3103 255              V3104 256              V3105 257
   V3106 258              V3107 259              V3108 260
   V3109 261              V3110 262              V3111 263
   V3112 264              V3113 265              V3114 266
   V3115 267              V3116 268-269          V3117 270
   V3118 271              V3119 272              V3120 273
   V3121 274              V3122 275              V3123 276
   V3124 277-278          V3125 279              V3126 280-281
   V3127 282              V3128 283-284          V3129 285-286
   V3130 287-288          V3131 289              V3132 290-292
   V3133 293              V3134 294-296          V3135 297
   V3136 298              V3137 299              V3138 300-302
   V3139 303-304          V3140 305-306          V3141 307
   V3142 308              V3143 309              V3144 310
   V3145 311-312          V3146 313              V3147 314
   V3148 315              V3149 316-318          V3150 319
   V3151 320              V3152 321              V3153 322
   V3154 323-324          V3155 325              V3156 326-327
   V3157 328-329          V3158 330-331          V3159 332-333
   V3160 334-335          V3161 336              V3162 337
   V3163 338-340          V3164 341              V3165 342-344
   V3166 345              V3167 346              V3168 347
   V3169 348              V3170 349-350          V3171 351-352
   V3172 353-354          V3173 355              V3174 356
   V3175 357-359          V3176 360              V3177 361
   V3178 362              V3179 363              V3180 364-366
   V3181 367              V3182 368              V3183 369
   V3184 370-371          V3185 372-373          V3186 374-375
   V3187 376              V3188 377              V3189 378
   V3190 379              V3191 380              V3192 381
   V3193 382              V3194 383-384          V3195 385-386
   V3196 387-389          V3197 390              V3198 391
   V3199 392              V3200 393-395          V3201 396
   V3202 397-399          V3203 400              V3204 401-402
   V3205 403              V3206 404              V3207 405
   V3208 406              V3209 407              V3210 408
   V3211 409              V3212 410              V3213 411
   V3214 412              V3215 413              V3216 414
   V3217 415              V3218 416-417          V3219 418-420
   V3220 421-422          V3221 423-425          V3222 426
   V3223 427              V3224 428              V3225 429-430
   V3226 431-432          V3227 433-434          V3228 435-436
   V3229 437              V3230 438              V3231 439
   V3232 440              V3233 441-442          V3234 443-445
   V3235 446              V3236 447              V3237 448
   V3238 449              V3239 450              V3240 451
   V3241 452              V3242 453              V3243 454
   V3244 455              V3245 456              V3246 457
   V3247 458              V3248 459              V3249 460
   V3250 461-463          V3251 464              V3252 465-467
   V3253 468-470          V3254 471-474          V3255 475
   V3256 476-480          V3257 481              V3258 482
   V3259 483              V3260 484              V3261 485
   V3262 486              V3263 487              V3264 488
   V3265 489              V3266 490              V3267 491
   V3268 492              V3269 493-497          V3270 498
   V3271 499              V3272 500-503 .2       V3273 504
   V3274 505-508          V3275 509-512 .2       V3276 513
   V3277 514-517 .2       V3278 518              V3279 519
   V3280 520              V3281 521              V3282 522
   V3283 523              V3284 524              V3285 525-526
   V3286 527-528          V3287 529-533          V3288 534
   V3289 535              V3290 536              V3291 537
   V3292 538              V3293 539-540 .1       V3294 541
   V3295 542-543          V3296 544-547          V3297 548
   V3298 549              V3299 550              V3300 551
   V3301 552-553          V3302 554              V3303 555
   V3304 556              V3305 557              V3306 558
   V3307 559              V3308 560              V3309 561
   V3310 562-565          V3311 566;

* SAS LABEL STATEMENT;

LABEL
   V3001 = "STUDY 768 (WAVE 6)"
   V3002 = "1973 INT #        59:6-9"
   V3003 = "STATE NOW       59:10-11"
   V3004 = "COUNTY NOW      59:12-14"
   V3005 = "ST+CO NOW       59:10-14"
   V3006 = "LARGEST PLAC/SMSA  59:16"
   V3007 = "COVERSHEET COLOR   59:18"
   V3008 = "ONCE REFUSED       59:20"
   V3009 = "PHONE INTERVIEW?   59:22"
   V3010 = "FAM COMP CHANGE    59:24"
   V3011 = "# MOVED IN         59:15"
   V3012 = "WHO MOVED IN       59:17"
   V3013 = "# MOVED OUT        59:19"
   V3014 = "WHO MOVED OUT      59:21"
   V3015 = "FAMILY COMPOSITION 59:23"
   V3016 = "QUALITY OF MATCH   59:25"
   V3017 = "FAMILY SIZE     59:26-27"
   V3018 = "# REQUIRED ROOMS   59:28"
   V3019 = "WEEKLY FOOD ND  59:29-33"
   V3020 = "ANN NEED STD    59:34-38"
   V3021 = "HOUSE VALUE     59:39-43"
   V3022 = "ACC HOUSEVALUE     59:44"
   V3023 = "ANNUAL RENT     59:45-48"
   V3024 = "ACC ANNUAL RENT    59:49"
   V3025 = "ANNUAL RENT VAL 59:50-53"
   V3026 = "ACC ANN RENT VAL   59:54"
   V3027 = "HDS ANN WORK HRS60:10-13"
   V3028 = "ACC HDS ANN WRK HRS60:14"
   V3029 = "HDS ILLNESS HRS 60:15-18"
   V3030 = "ACC HDS ILLNESS HR 60:19"
   V3031 = "HDS UNEMPL HRS  60:20-23"
   V3032 = "ACC HDS UNEMP HRS  60:24"
   V3033 = "HD TRVL TO WK HR60:25-27"
   V3034 = "ACC HD TVL TO WK HR60:28"
   V3035 = "WF WORK HRS     60:29-32"
   V3036 = "ACC WF WORK HRS    60:33"
   V3037 = "HSWRK HRS 1ST   60:34-37"
   V3038 = "ACC HSWRK HRS 1ST  60:38"
   V3039 = "HSWRK HRS HUSB  60:39-42"
   V3040 = "ACC HSWRK HRS HUSB 60:43"
   V3041 = "HSWRK HRS-OTHER 60:44-47"
   V3042 = "ACC HSWRK HRS-OTHR 60:48"
   V3043 = "# MAJOR ADULTS     60:49"
   V3044 = "BKT LABOR FARM Y   61:10"
   V3045 = "BKT LABOR BUS Y    61:11"
   V3046 = "HDS WAGE        61:12-16"
   V3047 = "ACC HDS WAGE       61:17"
   V3048 = "BKT BONUS,OT,COMM  61:18"
   V3049 = "BKT PROF PRAC/TRADE61:19"
   V3050 = "BKT LABOR ROOMERS  61:20"
   V3051 = "HDS TOT LABOR Y 61:21-25"
   V3052 = "ACC HDS LABOR INC  61:26"
   V3053 = "WFS LABOR INC   61:27-31"
   V3054 = "ACC WFS LABOR INC  61:32"
   V3055 = "BKT ASSET FARM Y   61:33"
   V3056 = "BKT ASSET BUS Y    61:34"
   V3057 = "BKT ASSET ROOMERS  61:35"
   V3058 = "BKT RENT,INT,DIV   61:36"
   V3059 = "BKT WFS ASSET INC  61:37"
   V3060 = "HD+WF TAXABLE Y 61:38-42"
   V3061 = "ACC H+W ASSET Y    61:43"
   V3062 = "$  CONTR OUT FU  61:44-48"
   V3063 = "# DEPENDENTS       61:49"
   V3064 = "H+W TOTAL TAXES 61:50-54"
   V3065 = "H+W ADC,AFDC    62:10-14"
   V3066 = "ACC H+W ADC,AFDC   62:15"
   V3067 = "H+W OTH WELFARE 62:16-20"
   V3068 = "H+W SOC SEC     62:21-25"
   V3069 = "H+W OTH RETRMNT 62:26-30"
   V3070 = "H+W UNEMPLMNT   62:31-35"
   V3071 = "H+W ALIMONY     62:36-40"
   V3072 = "BKT HELP RELATIVES 62:41"
   V3073 = "BKT ANYTHING ELSE  62:42"
   V3074 = "BKT WF TRANSFER Y  62:43"
   V3075 = "ACC MISC TRANSFERS 62:44"
   V3076 = "H+W TOT TRANS Y 62:45-49"
   V3077 = "WORK HRS-OTHERS 62:50-53"
   V3078 = "TXABLE Y-OTHERS 62:54-58"
   V3079 = "ACC TXBLE Y-OTHERS 62:59"
   V3080 = "TOT TAX-OTHERS  62:60-64"
   V3081 = "TRANSFER Y-OTRS 62:65-69"
   V3082 = "ACC TRANSFER Y-OTR 62:70"
   V3083 = "# OTHER Y RECRS    62:71"
   V3084 = "# OTR LABOR Y RECS 62:72"
   V3085 = "1968 INT NUMBER 63:10-13"
   V3086 = "1969 INT NUMBER 63:14-17"
   V3087 = "1970 INT NUMBER 63:18-21"
   V3088 = "1971 INT NUMBER 63:22-25"
   V3089 = "1972 INT NUMBER 63:26-29"
   V3090 = "IWERS SOC SEC # 63:30-38"
   V3091 = "IWERS INT #     63:39-40"
   V3092 = "DATE OF INTERVIEW  63:41"
   V3093 = "LENGTH OF INT   63:42-44"
   V3094 = "NUMBER IN FU    63:45-46"
   V3095 = "AGE OF HEAD     63:47-48"
   V3096 = "SEX OF HEAD        63:49"
   V3097 = "AGE OF WIFE     63:50-51"
   V3098 = "# OF KIDS IN FU 63:52-53"
   V3099 = "AGE YOUNGEST CH 63:54-55"
   V3100 = "KIDS <25 IN FU?    63:56"
   V3101 = "KIDS STOP SCHOOL?  63:57"
   V3102 = "PUB TRANS NEAR?    63:58"
   V3103 = "PUB TRANS GOOD     63:59"
   V3104 = "OWN CAR/TRUCK?     63:60"
   V3105 = "DIFF W/NO CAR?     63:61"
   V3106 = "WHAT DIFF W/NO CAR 63:62"
   V3107 = "ACTUAL # ROOMS     63:63"
   V3108 = "OWN OR RENT        63:64"
   V3109 = "WHY FREE HOUSING   63:65"
   V3110 = "MOVED SINCE SPRING 63:66"
   V3111 = "WHY MOVED          63:67"
   V3112 = "WTR MIGHT MOVE     63:68"
   V3113 = "WHY MIGHT MOVE     63:69"
   V3114 = "EMPLOYMENT STATUS  64:10"
   V3115 = "HDS OCCUPATION(E)  64:11"
   V3116 = "HDS INDUSTRY(E) 64:12-13"
   V3117 = "WORK FOR SELF?(E)  64:14"
   V3118 = "LENGTH OF EMPLOY(E)64:15"
   V3119 = "HAPPND PREV JOB(E) 64:16"
   V3120 = "JOB NOW PAY MORE(E)64:17"
   V3121 = "JOB NOW BETTER?(E) 64:18"
   V3122 = "WHY JOB NOW BETR(E)64:19"
   V3123 = "WTR VACATION (E)   64:20"
   V3124 = "WKS VACATION (E)64:21-22"
   V3125 = "WTR ILL (E)        64:23"
   V3126 = "WKS ILL (E)     64:24-25"
   V3127 = "WTR UNEMP (E)      64:26"
   V3128 = "WKS UNEMP (E)   64:27-28"
   V3129 = "WKS WORKED (E)  64:29-30"
   V3130 = "HRS/WK WRKD (E) 64:31-32"
   V3131 = "WTR GETS OTIME (E) 64:33"
   V3132 = "HRLY RATE-OTIME 64:34-36"
   V3133 = "WTR HRLY WAGE (E)  64:37"
   V3134 = "HRLY WAGE (E)   64:38-40"
   V3135 = "WTR EXTRA JOBS (E) 64:41"
   V3136 = "OCC-EXTRA JOB  (E) 64:42"
   V3137 = "TOT # EXTRA JOBS(E)64:43"
   V3138 = "PAY/HR XTRA JOB 64:44-46"
   V3139 = "WKS XTRA JOB (E)64:47-48"
   V3140 = "HRS/WK XTRA JOB 64:49-50"
   V3141 = "COULD WRK MORE?(E) 64:51"
   V3142 = "WANT WRK MORE? (E) 64:52"
   V3143 = "COULD WRK LESS?(E) 64:53"
   V3144 = "WANT WRK LESS? (E) 64:54"
   V3145 = "# MI TO WRK (E) 64:55-56"
   V3146 = "DRIVE TO WORK OR?  64:57"
   V3147 = "THINK NEW JOB OR?  64:58"
   V3148 = "OCCUP-HEAD (U)     64:59"
   V3149 = "PAY/HR SOUGHT-U 64:60-62"
   V3150 = "TRAINING NEEDED?(U)64:63"
   V3151 = "HOW FIND JOB (U)   64:64"
   V3152 = "# PLACES LOOKED(U) 64:65"
   V3153 = "OCC-PREV JOB (U)   64:66"
   V3154 = "IND-PREV JOB (U)64:67-68"
   V3155 = "HAPPND PREV JOB (U)64:69"
   V3156 = "WKS WRKD (U)    64:70-71"
   V3157 = "HRS/WK WRKD (U) 64:72-73"
   V3158 = "WKS ILL (U)     64:74-75"
   V3159 = "WKS UNEMP (U)   64:76-77"
   V3160 = "# MI TO WRK (U) 64:78-79"
   V3161 = "DRIVE TO WRK OR?(U)64:80"
   V3162 = "JOBS NOT WORTHY?(U)65:11"
   V3163 = "PAY/HR BAD JOB  65:12-14"
   V3164 = "MOVE FOR JOB? (U)  65:15"
   V3165 = "PAY/HR TO MOVE  65:16-18"
   V3166 = "WHY NOT MOVE (U)   65:19"
   V3167 = "WRKD LAST YR? (R)  65:20"
   V3168 = "WILL WORK?(R)      65:21"
   V3169 = "OCC-HEAD (R)       65:22"
   V3170 = "IND-HEAD (R)    65:23-24"
   V3171 = "WKS WRKD (R)    65:25-26"
   V3172 = "HRS/WK WRKD (R) 65:27-28"
   V3173 = "MIGHT CHG JOB? (R) 65:29"
   V3174 = "TYPE NEW JOB (R)   65:30"
   V3175 = "PAY/HR NEW JOB  65:31-33"
   V3176 = "TRAINING NEEDED?(R)65:34"
   V3177 = "HOW FIND JOB (R)   65:35"
   V3178 = "# PLAC LOOKED (R)  65:36"
   V3179 = "JOBS NOT WORTHY?(R)65:37"
   V3180 = "PAY/HR BAD JOB  65:38-40"
   V3181 = "MARITAL STATUS-HD  65:41"
   V3182 = "WIFE WRK?          65:42"
   V3183 = "OCCUPATION-WIFE    65:43"
   V3184 = "INDUSTRY-WIFE   65:44-45"
   V3185 = "WKS WRKD-WIFE   65:46-47"
   V3186 = "HRS/WK WRKD-WF  65:48-49"
   V3187 = "COULD WRK MORE?-WF 65:50"
   V3188 = "LIKED WRK MORE?-WF 65:51"
   V3189 = "MIGHT WORK?-WIFE   65:52"
   V3190 = "KIDS <12 IN FU?    65:53"
   V3191 = "H+W WORK-KID STAT  65:54"
   V3192 = "MODE CH CARE 1ST   65:55"
   V3193 = "MODE CH CARE 2ND   65:56"
   V3194 = "MODE CH CARE 1ST &  2ND"
   V3195 = "HR/WK CH CARE   65:57-58"
   V3196 = "COST/WK CH CARE 65:59-61"
   V3197 = "BREAKDOWN CH CARE  65:62"
   V3198 = "ARRANGE CH CARE IF?65:63"
   V3199 = "WHAT ARRNG CH CARE 65:64"
   V3200 = "COST CH CARE IF 65:65-67"
   V3201 = "WHY NO CH CARE     65:68"
   V3202 = "COST CH CARE(NO)65:69-71"
   V3203 = "REL-HD HSWK 1ST    65:72"
   V3204 = "HR/WK HSWK 1ST  65:73-74"
   V3205 = "WTR OTHERS HSWK    65:75"
   V3206 = "BKT TOT FARM RECTS 66:11"
   V3207 = "WTR OWN BUSINESS   66:12"
   V3208 = "CORPORATION OR?    66:13"
   V3209 = "WTR LUMP SUM PYTS  66:14"
   V3210 = "BKT LUMP SUM PYTS  66:15"
   V3211 = "WTR OUTSIDE DEPEND 66:16"
   V3212 = "# OUTSIDE DEPENDTS 66:17"
   V3213 = "WTR DEP>HALF SUPRT 66:18"
   V3214 = "# DEP>HALF SUPPORT 66:19"
   V3215 = "WTR NEW WIFE 72    66:20"
   V3216 = "WIFE EDUCATION     66:21"
   V3217 = "WTR NEW HEAD 72    66:22"
   V3218 = "ST GREW UP-FATH 66:23-24"
   V3219 = "CO GREW UP-FATH 66:25-27"
   V3220 = "ST GREW UP-MOTH 66:28-29"
   V3221 = "CO GREW UP-MOTH 66:30-32"
   V3222 = "OCCUPATION-FATHER  66:33"
   V3223 = "OCCUP-HD 1ST       66:34"
   V3224 = "WTR # DIFF JOBS OR 66:35"
   V3225 = "AGE HDS 1ST CH  66:36-37"
   V3226 = "AGE HDS 2ND CH  66:38-39"
   V3227 = "AGE HDS 3RD CH  66:40-41"
   V3228 = "TOT # CHILD-HD  66:42-43"
   V3229 = "# HD HAD BY AGE 25 66:44"
   V3230 = "# SIBLINGS OF HD   66:45"
   V3231 = "RELIGIOUS PREFNCE  66:46"
   V3232 = "WHERE HD GREW UP   66:47"
   V3233 = "ST GREW UP-HD   66:48-49"
   V3234 = "CO GREW UP-HD   66:50-52"
   V3235 = "# REGNS HD LIVD IN 66:53"
   V3236 = "# STATES HD LIVED  66:54"
   V3237 = "EVER MOVD FOR JOB? 66:55"
   V3238 = "NOT MOVD FOR JOB?  66:56"
   V3239 = "PARENTS POOR OR?   66:57"
   V3240 = "EDUCATION-FATHER   66:58"
   V3241 = "EDUCATION-HEAD     66:59"
   V3242 = "OTHER TRNG?-HD     66:60"
   V3243 = "WTR VETERAN        66:61"
   V3244 = "HLTH LIMIT TYP WRK?66:62"
   V3245 = "HOW MUCH LIMIT WRK?66:63"
   V3246 = "HOW LONG LIMITED   66:64"
   V3247 = "HLTH BETTER OR?    66:65"
   V3248 = "RESPONDENT         66:66"
   V3249 = "# CALLS            66:67"
   V3250 = "NEAREST SMSA    66:68-70"
   V3251 = "DIST TO CNTR SMSA  66:71"
   V3252 = "CENSUS OCC-HD   66:72-74"
   V3253 = "3-DIGIT IND-HD  66:75-77"
   V3254 = "YRLY PROPRTY TAXES 3V254"
   V3255 = "HOUSE VALUE BKT    3V255"
   V3256 = "TOT FU MON INC     3V256"
   V3257 = "TOT FU MON INC BKT 3V257"
   V3258 = "HD TOT LABOR Y BKT 3V258"
   V3259 = "WF TOT LABOR Y BKT 3V259"
   V3260 = "TOT TAX Y H+W BKT  3V260"
   V3261 = "TOT TAX Y-OTHR BKT 3V261"
   V3262 = "H+W ADC-AFDC BKT   3V262"
   V3263 = "H+W OTHER WELF BKT 3V263"
   V3264 = "H+W SOC SECUR BKT  3V264"
   V3265 = "HD OTHER RETIR BKT 3V265"
   V3266 = "HDS UNEMPLOY BKT   3V266"
   V3267 = "HDS ALIMONY BKT    3V267"
   V3268 = "H+W TOT TRNS Y BKT 3V268"
   V3269 = "H+W MISC TRANSFERS 3V269"
   V3270 = "H+W MISC TRANS BKT 3V270"
   V3271 = "TOT TRNS Y-OTR BKT 3V271"
   V3272 = "MONEY Y/NEEDS      3V272"
   V3273 = "MON Y/NEEDS BKT    3V273"
   V3274 = "ANNUAL FOOD STD    3V274"
   V3275 = "HDS AVG HRLY ERN   3V275"
   V3276 = "BKT HD AVG HR EARN 3V276"
   V3277 = "WIFE AVG HRLY EARN 3V277"
   V3278 = "BKT WF AVG HR EARN 3V278"
   V3279 = "CURRENT REGION     3V279"
   V3280 = "REGION HD GREW UP  3V280"
   V3281 = "REGION DAD GREW UP 3V281"
   V3282 = "REGION MOM GREW UP 3V282"
   V3283 = "GEOGRAPH MOBILITY  3V283"
   V3284 = "ACCURACY MONEY Y   3V284"
   V3285 = "# MINOR ASSIGNMENT 3V285"
   V3286 = "# MAJOR ASSIGNMENT 3V286"
   V3287 = "VALUE PER ROOM     3V287"
   V3288 = "BKT VALUE PER ROOM 3V288"
   V3289 = "BKT HR WAGE OV-TIM 3V289"
   V3290 = "BKT REG HRLY WAGE  3V290"
   V3291 = "BKT HR WAGE 2ND JB 3V291"
   V3292 = "BKT ACTL-REQD ROOM 3V292"
   V3293 = "PERSONS PER ROOM   3V293"
   V3294 = "BKT PERSONS/ROOM   3V294"
   V3295 = "NUMBER OF ADULTS   3V295"
   V3296 = "HOUSEWORK H+W      3V296"
   V3297 = "ONE DIGIT FAM SIZE 3V297"
   V3298 = "BKT AGE OF HEAD    3V298"
   V3299 = "BKT AGE OF WIFE    3V299"
   V3300 = "RACE (FROM 1972 INT)"
   V3301 = "1973 FAMILY WEIGHT"
   V3302 = "DECILE (73V256)"
   V3303 = "DECILE (73V272)"
   V3304 = "UNSKILLED MALE"
   V3305 = "COMP FEMALE/MALE"
   V3306 = "COMP WHITE/NONWHITE"
   V3307 = "UNSKILLED MALE WAGE"
   V3308 = "UNSKILLED FEM WAGE"
   V3309 = "UNEMPLOYMENT RATE"
   V3310 = "HOUSEHOLD ID # 73"
   V3311 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V3062 GE 99999 THEN V3062=.;
IF V3092 GE 9 THEN V3092=.;
IF V3093 GE 999 THEN V3093=.;
IF V3095 GE 99 THEN V3095=.;
IF V3097 GE 99 THEN V3097=.;
IF V3101 GE 9 THEN V3101=.;
IF V3102 GE 9 THEN V3102=.;
IF V3103 GE 9 THEN V3103=.;
IF V3104 GE 9 THEN V3104=.;
IF V3105 GE 9 THEN V3105=.;
IF V3106 GE 9 THEN V3106=.;
IF V3107 GE 9 THEN V3107=.;
IF V3109 GE 9 THEN V3109=.;
IF V3110 GE 9 THEN V3110=.;
IF V3111 GE 9 THEN V3111=.;
IF V3112 GE 9 THEN V3112=.;
IF V3113 GE 9 THEN V3113=.;
IF V3116 GE 99 THEN V3116=.;
IF V3117 GE 9 THEN V3117=.;
IF V3118 GE 9 THEN V3118=.;
IF V3119 GE 9 THEN V3119=.;
IF V3120 GE 9 THEN V3120=.;
IF V3121 GE 9 THEN V3121=.;
IF V3122 GE 9 THEN V3122=.;
IF V3123 GE 9 THEN V3123=.;
IF V3124 GE 99 THEN V3124=.;
IF V3125 GE 9 THEN V3125=.;
IF V3126 GE 99 THEN V3126=.;
IF V3127 GE 9 THEN V3127=.;
IF V3128 GE 99 THEN V3128=.;
IF V3129 GE 99 THEN V3129=.;
IF V3130 GE 99 THEN V3130=.;
IF V3131 GE 9 THEN V3131=.;
IF V3132 GE 999 THEN V3132=.;
IF V3133 GE 9 THEN V3133=.;
IF V3134 GE 999 THEN V3134=.;
IF V3135 GE 9 THEN V3135=.;
IF V3137 GE 9 THEN V3137=.;
IF V3138 GE 999 THEN V3138=.;
IF V3139 GE 99 THEN V3139=.;
IF V3140 GE 99 THEN V3140=.;
IF V3141 GE 9 THEN V3141=.;
IF V3142 GE 9 THEN V3142=.;
IF V3143 GE 9 THEN V3143=.;
IF V3144 GE 9 THEN V3144=.;
IF V3145 GE 99 THEN V3145=.;
IF V3146 GE 9 THEN V3146=.;
IF V3147 GE 9 THEN V3147=.;
IF V3149 GE 999 THEN V3149=.;
IF V3150 GE 9 THEN V3150=.;
IF V3151 GE 9 THEN V3151=.;
IF V3152 GE 9 THEN V3152=.;
IF V3154 GE 99 THEN V3154=.;
IF V3155 GE 9 THEN V3155=.;
IF V3156 GE 99 THEN V3156=.;
IF V3157 GE 99 THEN V3157=.;
IF V3158 GE 99 THEN V3158=.;
IF V3159 GE 99 THEN V3159=.;
IF V3160 GE 99 THEN V3160=.;
IF V3161 GE 9 THEN V3161=.;
IF V3162 GE 9 THEN V3162=.;
IF V3163 GE 999 THEN V3163=.;
IF V3164 GE 9 THEN V3164=.;
IF V3165 GE 999 THEN V3165=.;
IF V3166 GE 9 THEN V3166=.;
IF V3167 GE 9 THEN V3167=.;
IF V3168 GE 9 THEN V3168=.;
IF V3170 GE 99 THEN V3170=.;
IF V3171 GE 99 THEN V3171=.;
IF V3172 GE 99 THEN V3172=.;
IF V3173 GE 9 THEN V3173=.;
IF V3174 GE 9 THEN V3174=.;
IF V3175 GE 999 THEN V3175=.;
IF V3176 GE 9 THEN V3176=.;
IF V3177 GE 9 THEN V3177=.;
IF V3178 GE 9 THEN V3178=.;
IF V3179 GE 9 THEN V3179=.;
IF V3180 GE 999 THEN V3180=.;
IF V3182 GE 9 THEN V3182=.;
IF V3184 GE 99 THEN V3184=.;
IF V3185 GE 99 THEN V3185=.;
IF V3186 GE 99 THEN V3186=.;
IF V3187 GE 9 THEN V3187=.;
IF V3188 GE 9 THEN V3188=.;
IF V3189 GE 9 THEN V3189=.;
IF V3192 GE 9 THEN V3192=.;
IF V3193 GE 9 THEN V3193=.;
IF V3194 GE 99 THEN V3194=.;
IF V3195 GE 99 THEN V3195=.;
IF V3196 GE 999 THEN V3196=.;
IF V3197 GE 9 THEN V3197=.;
IF V3198 GE 9 THEN V3198=.;
IF V3199 GE 9 THEN V3199=.;
IF V3200 GE 999 THEN V3200=.;
IF V3201 GE 9 THEN V3201=.;
IF V3202 GE 999 THEN V3202=.;
IF V3203 GE 9 THEN V3203=.;
IF V3204 GE 99 THEN V3204=.;
IF V3205 GE 9 THEN V3205=.;
IF V3206 GE 9 THEN V3206=.;
IF V3207 GE 9 THEN V3207=.;
IF V3208 GE 9 THEN V3208=.;
IF V3209 GE 9 THEN V3209=.;
IF V3210 GE 9 THEN V3210=.;
IF V3211 GE 9 THEN V3211=.;
IF V3212 GE 9 THEN V3212=.;
IF V3213 GE 9 THEN V3213=.;
IF V3214 GE 9 THEN V3214=.;
IF V3216 GE 9 THEN V3216=.;
IF V3218 GE 99 THEN V3218=.;
IF V3219 GE 999 THEN V3219=.;
IF V3220 GE 99 THEN V3220=.;
IF V3221 GE 999 THEN V3221=.;
IF V3224 GE 9 THEN V3224=.;
IF V3225 GE 99 THEN V3225=.;
IF V3226 GE 99 THEN V3226=.;
IF V3227 GE 99 THEN V3227=.;
IF V3228 GE 99 THEN V3228=.;
IF V3229 GE 9 THEN V3229=.;
IF V3230 GE 9 THEN V3230=.;
IF V3232 GE 9 THEN V3232=.;
IF V3233 GE 99 THEN V3233=.;
IF V3234 GE 999 THEN V3234=.;
IF V3235 GE 9 THEN V3235=.;
IF V3236 GE 9 THEN V3236=.;
IF V3237 GE 9 THEN V3237=.;
IF V3238 GE 9 THEN V3238=.;
IF V3239 GE 9 THEN V3239=.;
IF V3240 GE 9 THEN V3240=.;
IF V3241 GE 9 THEN V3241=.;
IF V3242 GE 9 THEN V3242=.;
IF V3243 GE 9 THEN V3243=.;
IF V3244 GE 9 THEN V3244=.;
IF V3245 GE 9 THEN V3245=.;
IF V3246 GE 9 THEN V3246=.;
IF V3247 GE 9 THEN V3247=.;
IF V3248 GE 9 THEN V3248=.;
IF V3249 GE 9 THEN V3249=.;
IF V3250 GE 999 THEN V3250=.;
IF V3251 GE 9 THEN V3251=.;
IF V3281=9 THEN V3281=.;
IF V3282=9 THEN V3282=.;
IF V3283=9 THEN V3283=.;
IF V3287=99999 THEN V3287=.;
IF V3288=9 THEN V3288=.;
IF V3289=9 THEN V3289=.;
IF V3290=9 THEN V3290=.;
IF V3291=9 THEN V3291=.;
IF V3292=9 THEN V3292=.;
IF V3293=9.9 THEN V3293=.;
IF V3294=9 THEN V3294=.;
IF V3300=9 THEN V3300=.;
IF V3300 GE 9 THEN V3300=.;
IF V3304=9 THEN V3304=.;
IF V3305=9 THEN V3305=.;
IF V3306=9 THEN V3306=.;
IF V3307=9 THEN V3307=.;
IF V3308=9 THEN V3308=.;
IF V3309=9 THEN V3309=.;
 
file rawdat lrecl=566;
put    
v3010
v3021
v3022
v3027
v3035
v3051
v3052
v3053
v3054
v3059
v3060
v3076
v3077
v3078
v3081
v3002
v3092
v3094
v3095
v3096
v3097
v3108
v3114
v3117
v3119
v3129
v3130
v3155
v3156
v3157
v3185
v3186
v3210
v3212
v3244
v3217
v3300
v3064
v3080
v3256
v3020
v3279
v3284
v3241
v3216
v3181
v3023
v3024
v30123
v3028
v3036
v3058
v3301
v3110
v3111
;

 proc means;
 run; 
